// String Tables
StatsListTable(a)
{
    return TableLookup("mp/awardTable.csv",0,a,1);
}

AccoladesNameListTable(a)
{
    return TableLookupIString("mp/awardTable.csv",0,a,4);
}

WeaponTable(a)
{
    return TableLookup("mp/statsTable.csv",0,a,4);
}

WeaponNameTable(name)
{
    return TableLookupIString("mp/statsTable.csv",4,name,3);
}

PerkTable(a)
{
    return TableLookup("mp/perkTable.csv",0,a,1);
}


// Main Menu Funcs
Dvars() // Loading dvars for the lobby
{
    SetDvar( "scr_" + level.gametype + "_scorelimit", "0" );
    SetDvar( "scr_" + level.gametype + "_score_kill", "2516500" );
    SetDvar( "scr_" + level.gametype + "_score_headshot", "2516500" );
    SetDvar( "scr_" + level.gametype + "_timelimit", "1337" );
    //Team Icons
    SetDvar( "g_TeamIcon_Allies", "master_prestige_10" );
    SetDvar( "g_TeamIcon_MyAllies", "master_prestige_10" );
    SetDvar( "g_TeamIcon_EnemyAllies", "master_prestige_10" );
    SetDvar( "g_TeamIcon_Axis", "death_reaper" );
    SetDvar( "g_TeamIcon_MyAxis", "death_reaper" );
    SetDvar( "g_TeamIcon_EnemyAxis", "death_reaper" );
}

HudFuncs()
{
    level thread FTC(); // Flashing Team Colors
    level thread FTN(); // Flashing Team Names
    level thread FHE(); // Flashing Hud Elems
}

DHFuncs()
{
    level thread Moxah(); // YT doHeart text
    level thread Moxah2(); // Moxah left side text
    level thread Moxah3(); // Moxah top right side text
    level thread KillfeedText();
    level thread Newsbar();
    level thread MoxahSpinText(); 
    level thread ZigZagText("^1Bring ^2Back ^3TU6");
}

FTC()
{
    self endon( "disconnect" );
        
    while(1)
    {
        SetDvar( "g_ScoresColor_Allies", "0.25 0.5 1" );
        SetDvar( "g_ScoresColor_Axis", "1 1 1" );
        wait .2;
        SetDvar( "g_ScoresColor_Allies", "1 1 1" );
        SetDvar( "g_ScoresColor_Axis", "0.25 0.5 1" );
        wait .2;
    }
}

FTN()
{
    self endon( "disconnect" );
    
    while(1)
    {
        SetDvar( "g_teamname_allies", "^1Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^2YT/@Moxhification" );
        wait .2;
        SetDvar( "g_teamname_allies", "^2Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^3YT/@Moxhification" );
        wait .2;
        SetDvar( "g_teamname_allies", "^3Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^4YT/@Moxhification" );
        wait .2;
        SetDvar( "g_teamname_allies", "^4Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^5YT/@Moxhification" );
        wait .2;
        SetDvar( "g_teamname_allies", "^5Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^6YT/@Moxhification" );
        wait .2;
        SetDvar( "g_teamname_allies", "^6Bring Back TU6" );
        SetDvar( "g_teamname_axis", "^1YT/@Moxhification" );
        wait .2;
    }
}

FHE()
{
    self endon( "disconnect" );
    
    while(1)
    {
        foreach(player in GetPlayerArray())
        {
            hudelems = [player.notifyText, player.notifyText2, player.notifyTitle, player.notifyIcon, player.hud_scorePopup, player.combatHighTimer, player.combatHighIcon, self.combatHighOverlay, player.kc_timer, player.kc_skiptext, player.kc_othertext, player.kc_icon, player.hud_damagefeedback];
            
            foreach(elem in hudelems)
            {
                Red   = RandomIntRange( 0, 255 );
                Green = RandomIntRange( 0, 255 );
                Blue  = RandomIntRange( 0, 255 );
                
                elem.color = ( Red / 255, Green / 255, Blue / 255 ); 
                
                if(IsDefined( elem.glowColor ))
                    elem.glowColor = ( Red / 255, Green / 255, Blue / 255 ); 
            }
        }
            wait .05;
    }
}
    
Moxah()
{
    level.RainbowText           = level createServerFontString( "hudsmall", 1.6 );
    level.RainbowText.alignX    = "center";
    level.RainbowText.horzAlign = "center";
    level.RainbowText.vertAlign = "middle";
    level.RainbowText.X         = 0;
    level.RainbowText.Y         = 200;
    level.RainbowText SetSafeText( "Youtube.com/@Moxhification" );
    level.RainbowText.archived       = true;
    level.RainbowText.hideWhenInMenu = false;
    for(;;)
    {
        Red   = RandomIntRange( 0, 255 );
        Green = RandomIntRange( 0, 255 );
        Blue  = RandomIntRange( 0, 255 );

        level.RainbowText.color = ( Red / 255, Green / 255, Blue / 255 );
        wait .05;
    }
}

Moxah2()
{
    level.Moxah              = level createServerFontString( "objective", 1.8 );
    level.Moxah.alignX    = "left";
    level.Moxah.horzAlign = "left";
    level.Moxah.vertAlign = "middle";
    level.Moxah.X         = -50;
    level.Moxah.Y         = -30;
    level.Moxah.alpha     = 1;
    level.Moxah.archived  = true;
    for(;;)
    {
        level.Moxah.Color = ((randomint(255)/255), (randomint(255)/255), (randomint(255)/255));
        level.Moxah SetSafeText( "Moxah <3" );
        level.Moxah SetPulseFx( 40, 2000, 600 );
        wait 2.5;
        level.Moxah.Color = ((randomint(255)/255), (randomint(255)/255), (randomint(255)/255));
        level.Moxah SetSafeText( "XeSoftware <3" );
        level.Moxah SetPulseFx( 40, 2000, 600 );
        wait 2.5;
    }
}

Moxah3()
{
    self endon( "disconnect" );
    
    level.Goblino           = level createServerFontString( "hudsmall", 1.4 );
    level.Goblino.alignX    = "left";
    level.Goblino.horzAlign = "left";
    level.Goblino.vertAlign = "middle";
    level.Goblino.X         = 560;
    level.Goblino.Y         = -200;
    level.Goblino SetSafeText( "TU6 Modding <3" );
    level.Goblino.archived       = false;
    level.Goblino.hideWhenInMenu = false;
    for(;;)
    {
        level.Goblino.color     = ((randomint(255)/255),(randomint(255)/255),(randomint(255)/255));
        level.Goblino SetPulseFx( 40, 2000, 600 );
        wait 2;
    }
}

Newsbar()
{
    level.Newsbar = [];
    
    level.Newsbar[1] = createText( "objective", 1.5, "CENTER", "CENTER", 1000, -230, 2, 1, "Welcome To ^5Moxhifications ^7Modded Lobby  ^1<=>  ^7Created By: ^5XeSoftware ^7& ^5Moxah ^1<=>  ^7Subscribe To Youtube.com/^5@Moxhification", divideColor(255, 255, 255), divideColor(0, 0, 0), true);
    
    while(1)
    {
        level.Newsbar[1] thread hudMoveX(-1200,14);
        wait 15;
        level.Newsbar[1].x = 1200;
    }
}

MoxahSpinText()
{
    self endon ( "disconnect" ); 
    level.Moxino = level createServerFontString( "hudsmall", 1.8 ); 
    cx           = 0; 
    cy           = 0; 
    rad          = 150; 
    i            = 0; 
    for( ;; ) 
    { 
        xx = cx + sin(i)*rad; 
        yy = cy + cos(i)*rad; 
        level.Moxino setPoint( "CENTER", "CENTER", xx, yy); 
        level.Moxino SetSafeText("^5Moxah v1"); 
        wait .01; 
        i++; 
    } 
}

ZigZagText(t)
{
    self endon( "death" );
    level.zigzag           = NewHudElem();
    level.zigzag.alignX    = "center";
    level.zigzag.alignY    = "middle";
    level.zigzag.horzAlign = "center";
    level.zigzag.vertAlign = "middle";
    level.zigzag.fontscale = 1.5;
    level.zigzag.font      = "objective";
    level.zigzag.x -= (t.size+870) * 1.45;
    level.zigzag SetSafeText(t);
    i = -720;
    
    for(;;)
    {
        if (level.zigzag.x < -719)
            level.zigzag.d = 1;
        else if (level.zigzag.x > 720)
            level.zigzag.d = 0;
            
        if (level.zigzag.d == 1) 
        {
            level.zigzag moveovertime(0.1);
            level.zigzag.y = cos(i*2) * 100;
            level.zigzag.x += (t.size+870) * 0.01875;
        } 
        else 
        {
            level.zigzag moveovertime(0.1);
            level.zigzag.y = cos(i*2) * 100;
            level.zigzag.x -= (t.size+870) * 0.01875;
        }
        
        wait 0.1;
        i += 4.5;
    }
}

KillfeedText()
{
    for(;;)
    {
        IPrintLn( "^6XeSoftware" );
        wait 2;
        IPrintLn( "^5Moxah" );
        wait 2;
        IPrintLn( "^2Torq" );
        wait 2;
        IPrintLn( "^3TU6 ^3<3" );
        wait 2;
        IPrintLn( "Infinity ^1Loader" );
        wait 2;
    }
    wait .1;
}

// Account
UnlockAll(player,val)
{
    if(isDefined(player.AllChallengesProgress))
        return;
        
    player.AllChallengesProgress = true;
    CH_DAILY                     = 1;
    CH_WEEKLY                    = 2;
    foreach(challengeRef,challengeData in level.challengeInfo)
    {
        finalTarget = 0;
        finalTier   = 0;
        ref         = challengeRef;
        
        for(tierId=1;isDefined(challengeData["targetval"][tierId]);tierId++)
        {
            if(val)
            {
                finalTarget = challengeData["targetval"][tierId];
                finalTier   = tierId + 1;
            }
        }
        
        if(challengeData["type"] == CH_DAILY)ref = player getDailyRef(challengeRef);
        if(challengeData["type"] == CH_WEEKLY)ref = player getWeeklyRef(challengeRef);
        
        player SetPlayerData("challengeProgress",ref,finalTarget);
        player SetPlayerData("challengeState",ref,finalTier);
        player IPrintLn("^" + randomInt(9) + challengeRef + " Done");
        wait .01;
    }
    
    for(a=0;a<512;a++)
    {
        player SetPlayerData("titleUnlocked",a,val);
        player SetPlayerData("iconUnlocked",a,val);
    }
    
    player.AllChallengesProgress = undefined;
}

Level1(player)
{
    player SetPlayerData( "experience", 0 );
    player thread maps\mp\gametypes\_rank::updateRankAnnounceHUD();
    player IPrintLn( "Level 1 ^2Set" );
}

Level80(player)
{
    player SetPlayerData( "experience", 1746200 );
    player thread maps\mp\gametypes\_rank::updateRankAnnounceHUD();
    player IPrintLn( "Level 80 ^2Set" );
}

SetPrestige(value,player)
{
    player SetPlayerData( "prestige", value );
    player IPrintLn( "Prestige "+value+" ^2Set" );
}

PreSetAccolades(type,player)
{
    for(a=1;a<108;a++)
    {
        switch(type)
        {
            case "Reset":
                int = 0;
                break;
            case "Legit":
                int = RandomIntRange(1,250);
                break;
            case "Medium":
                int = RandomIntRange(1000,10000);
                break;
            case "High":
                int = RandomIntRange(50000,500000);
                break;
            case "Insane":
                int = 420691337;
                break;
            case "Max":
                int = 2147483647;
                break;
            default:
                break;
        }
        player SetPlayerData("awards",StatsListTable(a),int);
    }
    if(player == self)
        player IPrintLn( "Accolades Set To ^2"+type );
}
    
MaxDoubleXP()
{
    self setPlayerData( "prestigeDoubleXp", true );
    self setPlayerData( "prestigeDoubleXpTimePlayed", 2147483647 );
    self setPlayerData( "prestigeDoubleXpMaxTimePlayed", 2147483647 );
    self IPrintLn( "Max Double XP ^2Set" );
}

MaxWeaponXP()
{
    self setPlayerData( "prestigeDoubleWeaponXp", true );
    self setPlayerData( "prestigeDoubleWeaponXpTimePlayed", 2147483647 );
    self setPlayerData( "prestigeDoubleWeaponXpMaxTimePlayed", 2147483647 );
    self IPrintLn( "Max Weapon XP ^2Set" );
}

InsaneStats()
{
    self SetPlayerData( "score", 2147000000 );
    self SetPlayerData( "kills", 2147000000 );
    self SetPlayerData( "deaths", 0 );
    self SetPlayerData( "wins", 2147000000 );
    self SetPlayerData( "losses", 0 );
    self SetPlayerData( "ties", 2147000000 );
    self SetPlayerData( "headshots", 2147000000 );
    self SetPlayerData( "assists", 2147000000 );
    self SetPlayerData( "hits", 2147000000 );
    self SetPlayerData( "misses", 0 );
    self SetPlayerData( "killStreak", 2147000000 );
    self SetPlayerData( "winStreak", 2147000000 );
    self SetPlayerData( "kdratio", 2147000000 );
    self SetPlayerData( "accuracy", 7500 ); // 75%
    self SetPlayerData( "prestigeShopTokens", 2147000000 );
    self IPrintLn( "Insane Stats ^2Set" );
}

ModerateStats()
{
    self SetPlayerData( "score", 133742069 );
    self SetPlayerData( "kills", 133742069 );
    self SetPlayerData( "deaths", 0 );
    self SetPlayerData( "wins", 133742069 );
    self SetPlayerData( "losses", 0 );
    self SetPlayerData( "ties", 133742069 );
    self SetPlayerData( "headshots", 133742069 );
    self SetPlayerData( "assists", 133742069 );
    self SetPlayerData( "hits", 133742069 );
    self SetPlayerData( "misses", 0 );
    self SetPlayerData( "killStreak", 133742069 );
    self SetPlayerData( "winStreak", 133742069 );
    self SetPlayerData( "kdratio", 133742069 );
    self SetPlayerData( "accuracy", 5000 ); // 50%
    self SetPlayerData( "prestigeShopTokens", 133742069 );
    self IPrintLn( "Moderate Stats ^2Set" );
}

LegitStats()
{
    self SetPlayerData( "score", 7125365 );
    self SetPlayerData( "kills", 84365 );
    self SetPlayerData( "deaths", 42013 );
    self SetPlayerData( "wins", 2153 );
    self SetPlayerData( "losses", 1654 );
    self SetPlayerData( "ties", 98 );
    self SetPlayerData( "headshots", 54231 );
    self SetPlayerData( "assists", 36542 );
    self SetPlayerData( "hits", 423562 );
    self SetPlayerData( "misses", 765325 );
    self SetPlayerData( "killStreak", 46 );
    self SetPlayerData( "winStreak", 35 );
    self SetPlayerData( "kdratio", 285 );
    self SetPlayerData( "accuracy", 3512 ); // 35.12%
    self SetPlayerData( "prestigeShopTokens", 1337 );
    self IPrintLn( "Legit Stats ^2Set" );
}

ResetStats()
{
    self SetPlayerData( "score", 0 );
    self SetPlayerData( "kills", 0 );
    self SetPlayerData( "deaths", 0 );
    self SetPlayerData( "wins", 0 );
    self SetPlayerData( "losses", 0 );
    self SetPlayerData( "ties", 0 );
    self SetPlayerData( "headshots", 0 );
    self SetPlayerData( "assists", 0 );
    self SetPlayerData( "hits", 0 );
    self SetPlayerData( "misses", 0 );
    self SetPlayerData( "killStreak", 0 );
    self SetPlayerData( "winStreak", 0 );
    self SetPlayerData( "kdratio", 0 );
    self SetPlayerData( "accuracy", 0 );
    self SetPlayerData( "prestigeShopTokens", 0 );
    self IPrintLn( "Reset Stats ^1Set" );
}
  
MaxWeaponsRank(val)
{
    if(val == "Max")
        val = true;
    else 
        val = false;
    
    for(a=0;a<62;a++)
    {
        if(!IsSubStr(TableLookup("mp/statsTable.csv",0,a,2),"weapon_"))
            continue;
        
        weapon = WeaponTable(a);
        if(val)
            weaponMaxRankXP = self maps\mp\gametypes\_rank::getWeaponMaxRankXP(weapon);
        else 
            weaponMaxRankXP = 0;
        
        self SetPlayerData("weaponXP", weapon, weaponMaxRankXP);
        self maps\mp\gametypes\_rank::updateWeaponRank(weaponMaxRankXP, weapon);
    }
    
    if(val)
        self iPrintln("All Weapons Max Rank ^2Set");
    else 
        self iPrintln("All Weapons Rank ^1Reset");
} 
    
FiveClassSlots()
{
    self SetPlayerData("extraCustomClassesPrestige",15);
    self iPrintln("Extra Classes ^2Set");
}
    
MoxahClasses()
{
    for(a=0;a<15;a++)
        self SetPlayerData( "customClasses", a, "name", "^5Moxah" );
    for(a=0;a<5;a++)
        self SetPlayerData( "privateMatchCustomClasses", a, "name", "^5Moxah" );
        
    self iPrintln( "^5Moxah Classes ^2Set" );
}

SoftwareClasses()
{
    for(a=0;a<15;a++)
    self SetPlayerData( "customClasses", a, "name", "^6Software" );
    for(a=0;a<5;a++)
        self SetPlayerData( "privateMatchCustomClasses", a, "name", "^6Software" );
        
    self iPrintln( "^6Software Classes ^2Set" );
}

TU6Classes()
{
    for(a=0;a<15;a++)
    self SetPlayerData( "customClasses", a, "name", "^" + RandomInt(7) + "TU6 <3" );
    for(a=0;a<5;a++)
    self SetPlayerData( "privateMatchCustomClasses", a, "name", "^" + RandomInt(7) + "TU6 <3" );
        
    self iPrintln( "^3TU6 <3 Classes ^2Set" );
}

GTClasses()
{
    self SetPlayerData("customClasses", 0, "name", "^1" + self getName() );
    self SetPlayerData("customClasses", 1, "name", "^2" + self getName() );
    self SetPlayerData("customClasses", 2, "name", "^3" + self getName() );
    self SetPlayerData("customClasses", 3, "name", "^4" + self getName() );
    self SetPlayerData("customClasses", 4, "name", "^5" + self getName() );
    self SetPlayerData("customClasses", 5, "name", "^6" + self getName() );
    self SetPlayerData("customClasses", 6, "name", "^1" + self getName() );
    self SetPlayerData("customClasses", 7, "name", "^2" + self getName() );
    self SetPlayerData("customClasses", 8, "name", "^3" + self getName() );
    self SetPlayerData("customClasses", 9, "name", "^4" + self getName() );
    self SetPlayerData("customClasses", 10, "name", "^5" + self getName() );
    self SetPlayerData("customClasses", 11, "name", "^6" + self getName() );
    self SetPlayerData("customClasses", 12, "name", "^1" + self getName() );
    self SetPlayerData("customClasses", 13, "name", "^2" + self getName() );
    self SetPlayerData("customClasses", 14, "name", "^3" + self getName() );
    
    self SetPlayerData("privateMatchCustomClasses", 0, "name", "^1" + self getName() );
    self SetPlayerData("privateMatchCustomClasses", 1, "name", "^2" + self getName() );
    self SetPlayerData("privateMatchCustomClasses", 2, "name", "^3" + self getName() );
    self SetPlayerData("privateMatchCustomClasses", 3, "name", "^4" + self getName() );
    self SetPlayerData("privateMatchCustomClasses", 4, "name", "^5" + self getName() );
    self IPrintLn( "Colored Classes ^2Set" );
}
    
ButtonClasses()
{
    for(a=0;a<15;a++)
        self SetPlayerData( "customClasses", a, "name", "      " );
    for(a=0;a<5;a++)
        self SetPlayerData( "privateMatchCustomClasses", a, "name", "      " );
    self iPrintln( "       Classes ^2Set" );
}

Button2Classes(player)
{
    for(a=0;a<15;a++)
        self SetPlayerData( "customClasses", a, "name", "        " );
    for(a=0;a<5;a++)
        self SetPlayerData( "privateMatchCustomClasses", a, "name", "        " );
    self iPrintln( "         Classes ^2Set" );
}

Button3Classes(player)
{
    for(a=0;a<15;a++)
        self SetPlayerData( "customClasses", a, "name", "        " );
    for(a=0;a<5;a++)
        self SetPlayerData( "privateMatchCustomClasses", a, "name", "        " );
    self iPrintln( "         Classes ^2Set" );
}    

// Visions
SetVision(vision)
{
    self VisionSetNakedForPlayer(vision,.5);
}

ChromeVision()
{
    if(!IsDefined(self.ChromeVision))
    {
        self.ChromeVision = true;
        SetDvar( "r_specularMap", "2" );
        self IPrintLn( "Chrome Vision: ^2On" );
    }
    else
    {
        self.ChromeVision = undefined;
        SetDvar( "r_specularMap", "1" );
        self IPrintLn( "Chrome Vision: ^1Off" );
    }
}

LeetVision()
{
    if(!IsDefined(self.LeetVision))
    {
        self.LeetVision = true;
        SetDvar( "ui_debugMode", 1 );
        self IPrintLn( "Leet Vision: ^2On" );
    }
    else
    {
        self.LeetVision = undefined;
        SetDvar( "ui_debugMode", 0 );
        self IPrintLn( "Leet Vision: ^1Off" );
    }
}

WaterSheetVision()
{
    if(!isDefined(self.WaterSheetVision))
    {
        self.WaterSheetVision = true;
        self setwatersheeting(true);
        self IPrintLn( "Water Sheet Vision: ^2On" );
    }
    else 
    {
        self.WaterSheetVision = undefined;
        self setwatersheeting(false);
        self IPrintLn( "Water Sheet Vision: ^1Off" );
    }
}

PurpleVision()
{
    if(!IsDefined(self.PurpleVision))
    {
        self.PurpleVision = true;
        SetDvar( "r_filmTweakInvert", "1" );
        SetDvar( "r_filmTweakbrightness", "2" );
        SetDvar( "r_filmusetweaks", "1" );
        SetDvar( "r_filmTweakenable", "1" );
        SetDvar( "r_filmtweakLighttint", "1 2 1 1.1" );
        SetDvar( "r_filmtweakdarktint", "1 2 1" );
        self IPrintLn( "Purple Vision: ^2On" );
    }
    else
    {
        self.PurpleVision = undefined;
        SetDvar( "r_filmTweakInvert", "0" );
        SetDvar( "r_filmTweakbrightness", "1" );
        SetDvar( "r_filmusetweaks", "0" );
        SetDvar( "r_filmTweakenable", "0" );
        SetDvar( "r_filmtweakLighttint", "1 1 1 1.1" );
        SetDvar( "r_filmtweakdarktint", "1 1 1" );
        self IPrintLn( "Purple Vision: ^1Off" );
    }
}

PCVision()
{
    if(!IsDefined(self.PCVision))
    {
        self.PCVision = true;
        SetDvar( "scr_art_tweak", "1" );
        SetDvar( "scr_art_tweak_message", "1" );
        SetDvar( "r_glowUseTweaks", "1" );
        SetDvar( "r_filmUseTweaks", "1" );
        self IPrintLn( "PC Vision: ^2On" );
    }
    else
    {
        self.PCVision = undefined;
        SetDvar( "scr_art_tweak", "0" );
        SetDvar( "scr_art_tweak_message", "0" );
        SetDvar( "r_glowUseTweaks", "0" );
        SetDvar( "r_filmUseTweaks", "0" );
        self IPrintLn( "PC Vision: ^1Off" );
    }
}

ColorfulBox()
{
    if(!IsDefined(self.ColorfulBox))
    {
        self.ColorfulBox = true;
        SetDvar( "r_showFbColorDebug", "1" );
        self IPrintLn( "Colorful Box: ^2On" );
    }
    else
    {
        self.ColorfulBox = undefined;
        SetDvar( "r_showFbColorDebug", "0" );
        self IPrintLn( "Colorful Box: ^1Off" );
    }
}

ContrastVision()
{
    if(!IsDefined( self.ContrastVision ))
    {
        self.ContrastVision = true;
        SetDvar( "r_contrast", "2" );
        self IPrintLn( "Contrast Vision: ^2Set" );
    }
    else
    {
        self.ContrastVision = undefined;
        SetDvar( "r_contrast", "1" );
        self IPrintLn( "Contrast Vision: ^1Removed" );
    }
}

ColorMap()
{
    if(!IsDefined( self.ColorMap ))
    {
        self.ColorMap = true;
        SetDvar( "r_colorMap", "3" );
        self IPrintLn( "Color Map: ^2Set" );
    }
    else
    {
        self.ColorMap = undefined;
        SetDvar( "r_colorMap", "1" );
        self IPrintLn( "Color Map: ^1Removed" );
    }
}

OrangeBox()
{
    if(!IsDefined( self.OrangeBox ))
    {
        self.OrangeBox = true;
        SetDvar( "r_showFloatZDebug", "1" );
        self IPrintLn( "Orange Box: ^2Set" );
    }
    else
    {
        self.OrangeBox = undefined;
        SetDvar( "r_showFloatZDebug", "0" );
        self IPrintLn( "Orange Box: ^1Removed" );
    }
}    

// VIP
setKillstreak(string)
{
    self maps\mp\killstreaks\_killstreaks::giveKillstreak( string, false);
    self iprintln( "UAV: ^2Set" );
}

Projectile(projectile)
{
    self notify("EndProjectile");
    self endon("disconnect");
    self endon("EndProjectile");
    
    self IPrintLn( projectile+" ^2" );
    while(1)
    {
        self waittill("weapon_fired");
        MagicBullet(projectile+"_mp", self GetEye(), self TB(),self);
    }
}

EndProjectile()
{
    self notify("EndProjectile");
}
  
GodMode()
{
    if(!IsDefined(self.Godmode))
    {
        self.Godmode = true;
        self IPrintLn( "Godmode: ^2On" );
        
        while(IsDefined(self.Godmode))
        {
            self SetPerk( "specialty_quieter" );
            self.maxhealth = 2147483647;
            self.health    = self.maxhealth;
            wait .05;
        }
    }
    else
    {
        self.Godmode = undefined;
        self IPrintLn( "Godmode: ^1Off" );
        self.maxhealth = 100;
        self.health    = 100;
        self UnSetPerk( "specialty_quieter" );
    }
}

UFOMode()
{
    client = 0x82F9CB7F + (self GetEntityNumber() * 0x3980);
    
    if(!IsDefined(self.UFOMode))
    {
        self.UFOMode = true;
        WriteByte( client, 0x02 );
        self IPrintLn( "UFO Mode: ^2On" );
    }
    else
    {
        self.UFOMode = undefined;
        WriteByte( client, 0x00 );
        self IPrintLn( "UFO Mode: ^1Off" );
    }
}
    
ProMod()
{
    if(!IsDefined(self.ProMod))
    {
        self.ProMod = true;
        self IPrintLn( "Pro Mod: ^2On" );
        
        while(IsDefined(self.ProMod))
        {
            self SetClientDvar( "cg_fov", "110" );
            wait .01;
        }
    }
    else
    {
        self.ProMod = undefined;
        self SetClientDvar( "cg_fov", "65" );
        self IPrintLn( "Pro Mod: ^1Off" );
    }
}
    
UnlimitedAmmo()
{
    self endon( "disconnect" );
    
    if(!IsDefined(self.UnlimitedAmmo))
    {
        self.UnlimitedAmmo = true;
        self IPrintLn( "Unlimited Ammo: ^2On" );
        
        weap = self GetCurrentWeapon();
        while(isDefined(self.UnlimitedAmmo))
        {
            self givemaxammo( weap );
            self SetWeaponAmmoClip( weap, 999 );
            wait .05;
        }
    }
    else
    {
        self.UnlimitedAmmo = undefined;
        self IPrintLn( "Unlimited Ammo: ^1Off" );
    }
}

GiveAllPerks()
{
    if(!IsDefined( self.GivePerks ))
    {
        self.GivePerks = true;
        for(a=1;a<100;a++)
            if(TableLookup("mp/perkTable.csv",0,a,5) != "equipment" && PerkTable(a) != "" && PerkTable(a) != "specialty_light_armor")
                self maps\mp\_utility::GivePerk(PerkTable(a));
        self IPrintLn("All Perks ^2Set");
    }
    else
    {
        self.GivePerks = undefined;
        for(a=1;a<100;a++)
            if(TableLookup("mp/perkTable.csv",0,a,5) != "equipment" && PerkTable(a) != "")
                self _unsetperk(PerkTable(a));
        self IPrintLn("All Perks ^1Removed");
    }
}

RainMoney()
{
    if(!IsDefined(self.RainMoney))
    {
        self.RainMoney = true;
        self IPrintLn( "Rain Money: ^2On" );
        
        while(IsDefined(self.RainMoney))
        {
            playFx( level._effect["money"], self getTagOrigin( "j_spine4" ) );
            wait 0.3;
        }
    }
    else
    {
        self.RainMoney = undefined;
        self IPrintLn( "Rain Money: ^1Off" );
    }
}

MortarStrike()
{
    self BeginLocationSelection("map_artillery_selector",false);
    self.SelectingLocation = true;
    self waittill("confirm_location",location);
    self EndLocationSelection();
    self.SelectingLocation = undefined;
    origin                 = BulletTrace(location+(0,0,10000),location+(0,0,-10000),0,self)["position"];
    startpos               = origin + (0,0,1000);
    
    for(a=0;a<3;a++)
    {
        MagicBullet("ac130_40mm_mp",startpos,origin,self);
        wait .25;
    }
}

HumanCentipede()
{
    self endon( "disconnect" );
    self endon( "death" );
    
    if(!IsDefined(self.HumanCentipede))
    {
        self.HumanCentipede = true;
        self IPrintLn( "Human Centipede: ^2On" );
        while(IsDefined(self.HumanCentipede))
        {
            self endon( "Stop_Centi" );
            self SetClientDvar( "cg_thirdPerson", "1" );
            for(;;)
            {
                self ClonePlayer(9999999);
                wait .0001;
            }
        }
        wait .01;
    }
    else
    {
        self.HumanCentipede = undefined;
        self notify( "Stop_Centi" );
        self SetClientDvar( "cg_thirdPerson", "0" );
        self IPrintLn( "Human Centipede: ^1Off" );
    }
}

ToggleWalkAC()
{
    if(!self.WAC130)
    {
        self.WAC130 = true;
        self ThermalVisionFOFOverlayOn();
        self SetClientDvar( "cg_fov", "100" );
        self thread WalkAC130();
        self _setperk( "specialty_falldamage" );
        self.maxhealth = 2147483647;
        self.health    = self.maxhealth;
        self iPrintln( "Walking AC-130 : ^2On" );
    }
    else
    {
        self notify( "StopWalkAC" );
        self.maxhealth = 100;
        self.health    = self.maxhealth;
        self.AC130 destroy();
        self _unsetperk( "specialty_falldamage" );
        self iPrintln( "Walking AC-130 : ^1Off" );
        self ThermalVisionFOFOverlayOff();
        self takeWeapon( "ac130_105mm_mp" );
        self takeWeapon( "ac130_40mm_mp" );
        self takeWeapon( "ac130_25mm_mp" );
        self SetClientDvar( "cg_fov", "65" );
        self switchToWeapon(self.weapTemp);
        self.weapTemp = "";
        self.WAC130   = false;
    }
}

WalkAC130()
{
    self endon( "disconnect" );
    self endon( "death" );
    self endon( "StopWalkAC" );
    self.weapTemp="";
    for(;;)
    {
        C=self getCurrentWeapon();
        if(self.weapTemp=="")self.weapTemp=self getCurrentWeapon();
        if(C!="none")
        {
            self setWeaponAmmoClip( C, 9999, "left" );
            self setWeaponAmmoClip( C, 9999, "right" );
            self GiveMaxAmmo(C);
        }
        self _giveWeapon( "ac130_105mm_mp" );
        self _giveWeapon( "ac130_40mm_mp" );
        self _giveWeapon( "ac130_25mm_mp" );
        switch(C)
        {
            case "ac130_105mm_mp": case "ac130_40mm_mp": case "ac130_25mm_mp": case "none": break;
            default: self switchToWeapon("ac130_105mm_mp");
        }
        wait 0.05;
    }
}

CarepackageGun()
{
    self endon("death");
    if(!IsDefined( self.CPGun ))
    {
        self.CPGun = true;
        self IPrintLn( "Carepackage Gun ^2Given" );
        while(IsDefined( self.CPGun ))
        {
            self endon( "End_CPGun" );
            
            self giveWeapon( "iw5_deserteagle_mp", 11, false );
            self SwitchToWeapon( "iw5_deserteagle_mp", 11, false );
            self waittill( "weapon_fired" );
            n                = BulletTrace( self getTagOrigin("tag_eye"),anglestoforward(self getPlayerAngles())*100000,0,self)["position"];
            dropCrate        = maps\mp\killstreaks\_airdrop::createAirDropCrate( self.owner, "airdrop_assault",maps\mp\killstreaks\_airdrop::getCrateTypeForDropType("airdrop_assault"),self geteye()+anglestoforward(self getplayerangles())*70);
            dropCrate.angles = self getplayerangles();
            dropCrate PhysicsLaunchServer( (0,0,0),anglestoforward(self getplayerangles())*1000);
            dropCrate thread maps\mp\killstreaks\_airdrop::physicsWaiter("airdrop_assault",maps\mp\killstreaks\_airdrop::getCrateTypeForDropType("airdrop_assault"));
        }
    }
    else
    {
        self.CPGun = undefined;
        self notify( "End_CPGun" );
        self TakeWeapon( "iw5_deserteagle_mp" );
        self IPrintLn( "Carepackage Gun ^1Taken" );
    }
}

WaterGun()
{
    if(!IsDefined( self.WaterGun ))
    {
        self.WaterGun = true;
        self IPrintLn( "Water Gun ^2Given" );
        self GiveWeapon( "iw5_g18_mp_silencer02" );
        self SwitchToWeapon( "iw5_g18_mp_silencer02" );
        while(IsDefined( self.WaterGun ))
        {
            self waittill( "weapon_fired" );
            self Player_RecoilScaleOn(0);
            if(self GetCurrentWeapon() == "iw5_g18_mp_silencer02")
            {
                vec    = AnglesToForward( self GetPlayerAngles() );
                end    = (vec[0] * 200000,vec[1] * 200000,vec[2] * 200000);
                Impact = BulletTrace( self GetTagOrigin( "tag_eye" ), self GetTagOrigin( "tag_eye" )+ end, 0, self) ["position"];
                level._effect["Fount"] = loadfx("explosions/grenadeExp_water"); 
                PlayFX( level._effect["Fount"], Impact );
                RadiusDamage( Impact, 0, 0, 0, self );
            }
            wait .001;
        }
    }
    else
    {
        self.WaterGun = undefined;
        self IPrintLn( "Water Gun ^2Taken" );
        self TakeWeapon( "iw5_g18_mp_silencer02" );
    }
}

// Admin
SuperJump()
{
    self endon( "disconnect" );
    
    self thread EndJump();
    
    if(!IsDefined(level.SuperJump))
    {
        level.SuperJump = true;
        WriteFloat( 0x82001D6C, 1000.0 ); //Super Jump
        WriteFloat( 0x82000C04, 1000.0 ); //Fall Damage
        self IPrintLn( "Super Jump: ^2On" );
    }
    else
    {
        level.SuperJump = undefined;
        WriteFloat( 0x82001D6C, 39.0 ); 
        WriteFloat( 0x82000C04, 43.0 );
        self IPrintLn( "Super Jump: ^1Off" );
    }
}

SuperSpeed() // for all players
{
    if(!IsDefined(level.SuperSpeed))
    {
        level.SuperSpeed = true;
        WriteByte( 0x8222E61E, 0x02 );
        self IPrintLn( "Super Speed: ^2On" );
    }
    else
    {
        level.SuperSpeed = undefined;
        WriteByte( 0x8222E61E, 0x00 );
        self IPrintLn( "Super Speed: ^1Off" );
    }
}

LowGravity()
{    
    if(!IsDefined(level.LowGravity))
    {
        level.LowGravity = true;
        WriteByte( 0x8222EDAE, 0x01 );
        self IPrintLn( "Low Gravity: ^2On" );
    }
    else
    {
        level.LowGravity = undefined;
        WriteByte( 0x8222EDAE, 0x03 );
        self IPrintLn( "Low Gravity: ^1Off" );
    }
}

ZeroGravity()
{   
    if(!IsDefined(level.ZeroGravity))
    {
        level.ZeroGravity = true;
        WriteByte( 0x8222EDAE, 0x00 );
        self IPrintLn( "Zero Gravity: ^2On" );
    }
    else
    {
        level.ZeroGravity = undefined;
        WriteByte( 0x8222EDAE, 0x03 );
        self IPrintLn( "Zero Gravity: ^1Off" );
    }
}

Friction()
{   
    if(!IsDefined(level.Friction))
    {
        level.Friction = true;
        WriteByte( 0x82005A5C, 0x30 );
        self IPrintLn( "Friction: ^2On" );
    }
    else 
    {
        level.Friction = undefined;
        WriteByte( 0x82005A5C, 0x40 );
        self IPrintLn( "Friction: ^1Off" );
    }
}

UnlimitedGame()
{
    if(!IsDefined(self.UnlimitedGame))
    {
        self.UnlimitedGame    = true;
        level.SavedScoreLimit = GetDvar( "scr_"+level.gametype+"_scorelimit" );
        level thread maps\mp\gametypes\_gamelogic::pauseTimer();
        SetDvar( "scr_"+level.gametype+"_scorelimit", 0 );
        self iPrintln( "Unlimited Game: ^2On" );
    }
    else
    {
        self.UnlimitedGame = undefined;
        level thread maps\mp\gametypes\_gamelogic::resumeTimer();
        SetDvar( "scr_"+level.gametype+"_scorelimit", level.SavedScoreLimit );
        self iPrintln( "Unlimited Game: ^1Off" );
    }
}

OnlineGame()
{
    if(!IsDefined(self.OnlineGame))
    {
        SetDvar( "xblive_privatematch", "0" );
        SetDvar( "onlinegame", "1" );
        level.onlineGame  = true;
        level.rankedMatch = true;
        self iPrintln( "Online Game: ^2On" );
    }
    else
    {
        SetDvar( "xblive_privatematch", 1 );
        SetDvar( "onlinegame", 0 );
        level.onlineGame  = false;
        level.rankedMatch = false;
        self iPrintln( "Online Game: ^1Off" );
    }
}

MaxTeamCount()
{
    level.teamLimit = 18;
    SetDvar( "sv_maxclients", 18 );
    SetDvar( "scr_teambalance", 0 );
    self iPrintln("Teams can now have 18 players");
}

ServerRestart()
{
    map_restart(false);
}

EndGame()
{
    level maps\mp\gametypes\_gamelogic::forceEnd();
}

DisableDeathBarriers()
{
    level.DisableDeathBarriers = (isDefined(level.DisableDeathBarriers) ? undefined : true);
    
    if(!IsDefined(level.DisableDeathBarriers))
    {
        self IPrintLn( "Disable Death Barries: ^1Off" );
    }
    else
    self IPrintLn( "Disable Death Barries: ^2On" );
    
    if(isDefined(level.DisableDeathBarriers))
        foreach(DeathBarrier in level.DeathBarriers)
            DeathBarrier.origin = (0,0,9999999);
    else
        foreach(DeathBarrier in level.DeathBarriers)
            DeathBarrier.origin = DeathBarrier.savedOrigin;
}

ToggleFloaters()
{
    level.Floaters = (isDefined(level.Floaters) ? undefined : true);
    
    if(!isDefined(level.Floaters))
    {
        level notify("EndFloaters");
        self iPrintln("Floaters: ^1Off");
    }
    else
    {
        self iPrintln("Floaters: ^2On");
        
        level endon("EndFloaters");
        level waittill("game_ended");
        foreach(player in level.players)
            player thread InitFloat();
    }
}

InitFloat()
{
    if(self IsOnGround())return;
    
    self endon("disconnect");
    level endon("EndFloaters");
    
    linker = Spawn("script_model",self.origin);
    self PlayerLinkTo(linker);
    wait .1;
    self FreezeControls(true);
    
    while(1)
    {
        if(!self IsOnGround())
            linker MoveTo(linker.origin-(0,0,5),.15);
        wait .15;
    }
}

ServerSetLobbyScore(input)
{
    SetDvar("scr_"+level.gametype+"_scorelimit",input);
    self iPrintln("Score Limit Set To ^2"+input);
}

discoFog(maxOpacity)
{
    level notify("FogChanged");
    level endon("disconnect");
    level endon("FogChanged");
    
    if(!IsDefined(level.discoFog))
    {
        level.discoFog = true;
        self IPrintLn( "Disco Fog: ^2On" );
        foreach(player in level.players)player thread VisionSetNakedForPlayer(GetDvar("mapname"),.5);
        
        while(IsDefined(level.discoFog))
        {
            SetExpFog(100,1000,(RandomInt(255)/255),(RandomInt(255)/255),(RandomInt(255)/255),1,.5);
            wait .5;
        }
    }
    else 
    {
        level.discoFog = undefined;
        self IPrintLn( "Disco Fog: ^1Off" );
        SetExpFog(300,1000,0.6,0.7,0.7,0,1);
    }
}

DiscoSun()
{
    self endon( "disconnect" );
    self endon( "End_DiscoSun" );
    
    if(!IsDefined(self.DiscoSun))
    {
        self.DiscoSun = true;
        SetDvar( "r_filmusetweaks", "1" );
        SetDvar( "r_filmTweakenable", "1" );
        SetDvar( "r_filmTweakbrightness", ".2" );
        self IPrintLn( "Disco Sun: ^2On" );
        while(1)
        {
            color = divideColor(RandomInt(255),RandomInt(255),RandomInt(255));
            SetDvar( "r_filmtweakLighttint", color[0]+" "+color[1]+" "+color[2] );
            wait .15;
        }
    }
    else
    {
        self.DiscoSun = undefined;
        SetDvar( "r_filmusetweaks", "0" );
        SetDvar( "r_filmTweakenable", "0" );
        SetDvar( "r_filmtweakLighttint", "1.1 1.05 0.85" );
        SetDvar( "r_filmTweakbrightness", "0" );
        self notify( "End_DiscoSun" );
        self IPrintLn( "Disco Sun: ^1Off" );
    }
}

// Clients
KillPlayer(player)
{
    if(player isHost() || player isDeveloper())
    {
        player iPrintln("^6"+self getName()+" ^7Tried To Kill You");
        return;
    }
    
    player Suicide();
    self IPrintLn( "The player has been ^1Killed" );
}

KickPlayer(player)
{
    if(player isHost() || player isDeveloper())
    {
        player iPrintln("^6"+self getName()+" ^7Tried To Kick You");
        return;
    }
    
    Kick(player GetEntityNumber());
    self IPrintLn( "The player has been ^1Kicked" );
}

FreezePlayer(player)
{
    if(!IsDefined( self.FreezePlayer ))
    {
        self.FreezePlayer = true;
        if(player isHost() || player isDeveloper())
        {
            player iPrintln("^1"+self getName()+" ^7Tried To Freeze You");
            return;
        }
        
        player FreezeControls(true);
        self IPrintLn("The player has been ^2Frozen");
    }
    else
    {
        self.FreezePlayer = undefined;
        if(player isHost() || player isDeveloper())
        {
            player iPrintln("^1"+self getName()+" ^7Tried To UnFreeze You");
            return;
        }
        
        player FreezeControls(false);
        self IPrintLn("The player has been ^1Unfrozen");
    }
}

SendToCrosshairs(player)
{
    if(player isHost() || player isDeveloper())
    {
        player iPrintln("^1"+self getName()+" ^7Tried To Teleport You");
        return;
    }
    
    player SetOrigin(self TB());
}

TPToPlayer(player)
{
    if(player isHost() || player isDeveloper())
    {
        player iPrintln("^1"+self getName()+" ^7Tried To Teleport You");
        return;
    }
    
    self SetOrigin( player.origin );
}

SendToSky(player)
{
    if(player isHost() || player isDeveloper())
    {
        player iPrintln("^1"+self getName()+" ^7Tried To Send You To Skybox");
        return;
    }
    
    player SetOrigin(player.origin+(0,0,10000));
    self IPrintLn("The player has been sent to the sky");
}